<?php
/* --------------------------------------------------------------
   LanguageSorting.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\SqlCriteria;

use Gambio\Core\Criteria\SqlSorting;
use Webmozart\Assert\Assert;

/**
 * Class LanguageSorting
 *
 * @package Gambio\Core\Language\SqlCriteria
 */
class LanguageSorting implements SqlSorting
{
    /**
     * @var string
     */
    private $attribute;
    
    /**
     * @var string
     */
    private $order;
    
    /**
     * @var string[]
     */
    private $attributeColumnMapping = [
        'id'        => 'languages_id',
        'name'      => 'name',
        'code'      => 'code',
        'sortOrder' => 'sort_order',
    ];
    
    
    /**
     * LanguageSorting constructor.
     *
     * @param string $attribute
     * @param string $order
     */
    public function __construct(string $attribute, string $order)
    {
        $attributes = array_keys($this->attributeColumnMapping);
        Assert::oneOf($attribute,
                      $attributes,
                      'Provided attribute needs to be one of: ' . implode(', ', $attributes) . '; Got: ' . $attribute);
        Assert::oneOf($order, ['asc', 'desc'], 'Provided order needs to be one of: asc, desc; Got: ' . $order);
        
        $this->attribute = $attribute;
        $this->order     = $order;
    }
    
    
    /**
     * @param string $attribute
     * @param string $order
     *
     * @return LanguageSorting
     */
    public static function create(string $attribute, string $order = 'asc'): LanguageSorting
    {
        return new self($attribute, strtolower($order));
    }
    
    
    /**
     * @return string
     */
    public function attribute(): string
    {
        return $this->attribute;
    }
    
    
    /**
     * @return string
     */
    public function order(): string
    {
        return $this->order;
    }
    
    
    /**
     * @return string
     */
    public function column(): string
    {
        return $this->attributeColumnMapping[$this->attribute];
    }
}